varying vec4 p_color;
varying vec2 p_textureCoord;

varying vec3 p_lightVec; 
varying vec3 p_normal;

uniform vec3 p_ambientColor;

uniform sampler2D base_texture;

void main()
{
    vec4 baseColor = texture2D(base_texture, p_textureCoord) * p_color;
    vec4 resultColor;
    resultColor.a = baseColor.a;
    

    lowp float diffuse_factor = max(dot(p_normal, p_lightVec), 0.0);
    resultColor.xyz =  diffuse_factor * baseColor.xyz + 
                        + p_ambientColor * baseColor.xyz;
    
    gl_FragColor = resultColor;
}
